#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;
attribute vec2 inTexCoord0;

uniform mat4 scalerMatrix;

varying vec3 normal;
varying vec2 vTexCoord;
#else
in vec3 inVertex;
in vec3 inNormal;
in vec2 inTexCoord0;

in mat4 scalerMatrix;

out vec3 normal;
out vec2 vTexCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

void main()
{
	normal = inNormal;
	vTexCoord = inTexCoord0;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
